#include <iostream>
#include <random>
#include <chrono>
#include <cmath>
#include <vector>
#include <set>
#include <map>
#include <unordered_map>
#include <algorithm>
#include <string>
#include <iomanip>
#include <cstdio>

using namespace std;

#define int ll
#define ll long long
#define pii pair<int, int>
#define ld long double

mt19937 rnd(chrono::system_clock().now().time_since_epoch().count());

const int INF = 1e9 + 50;

vector <int> palindroms;

void build() {
    for (int i = 1; i < 1000;  i++) {
        string s = to_string(i);
        reverse(s.begin(), s.end());
        if (to_string(i) == s) {
            palindroms.push_back(i);
        }
    }
}

vector <int> dp;

void build_2() {
    dp.assign(3000, INF);
    for (int i : palindroms) {
        dp[i] = 1;
    }
    for (int i = 1; i<= 1000; i++) {
        for (int j: palindroms) {
            dp[i + j] = min(dp[i + j], dp[i] + 1);
        }
    }
}

void solve() {
    int n;
    cin >> n;
    cout << dp[n] << "\n";
}

signed main() {
    ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0);
    #ifdef DEBUG
        freopen("input.txt", "r", stdin);
        freopen("output.txt", "w", stdout);
    #endif
    build();
    build_2();
    int t;
    cin >> t;
    while (t--) {
        solve();
    }
    
}